#include "pvmuser.h"
#include "pvm_consts.h"
#include "xab.h"

void
FUNCTION(finitiatem) ARGS(`STRING_ARG(aout), STRING_ARG(host), inum')
STRING_ARG_DECL(aout);
STRING_ARG_DECL(host);
int *inum;
{
	char taout[MAX_PROC_NAME + 1];
	char thost[MAX_HOST_NAME + 1];

	/*
	 * Copy the program and host names to make sure there's
	 * a NUL at the end.
	 * If either the program name or the host name is too
	 * long, just return an error.
	 */

	if (STRING_LEN(aout) > MAX_PROC_NAME
		|| STRING_LEN(host) > MAX_HOST_NAME) {
		*inum = pvm_uerr("finitiatem", PvmTooLong);
		return;
	}
	strncpy(taout, STRING_PTR(aout), STRING_LEN(aout));
	taout[STRING_LEN(aout)] = '\0';
	strncpy(thost, STRING_PTR(host), STRING_LEN(host));
	thost[STRING_LEN(host)] = '\0';
	*inum = initiateM(taout, thost);
}
